<?php require 'includes/header.php'; ?>

<style>
    p {
        text-align: justify;
    }
    ul {
        margin-left: 20px;
    }
</style>

<main class="main">

    <!-- Page Title -->
    <div class="page-title" data-aos="fade">
        <div class="container">
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="index.php">Home</a></li>
                    <li class="current">Abstracts</li>
                    <li class="current">Abstracts Guidelines</li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Abstract Guidelines Section -->
    <section id="abstracts" class="contact section">
        <div class="container sub-header-titel aos-init aos-animate" data-aos="fade-up">
            <h2>Abstracts Guidelines</h2>
        </div>

        <div class="container" data-aos="fade-up" data-aos-delay="100">
            <div class="row gy-4">
                <div class="col-12">

                    <p><strong>Abstract Submission Closes:</strong> 15th September 2025</p>
                    <p><strong>Abstract Acceptance Notification:</strong> 15th October 2025</p>
                    <p><em>Note: Acceptance of abstract as paper or poster is subject to approval by the Abstract Committee. The decision of the committee is final.</em></p>

                    <h4>Guidelines for Abstract Submission:</h4>
                    <ul>
                        <li>Each author can present only 1 abstract.</li>
                        <li>Abstracts submitted should preferably be original research work.</li>
                        <li>Abstracts already published or presented at previous conferences should not be submitted.</li>
                        <li>Abstracts may be submitted for oral/poster presentation.</li>
                        <li>Abstracts will be accepted only via online form. Abstracts sent by email will not be accepted.</li>
                        <li>Abstracts received after the deadline will not be considered.</li>
                    </ul>

                    <h4>Abstract Category (Choose any one):</h4>
                    <ul>
                        <li>Pre-conceptional Care</li>
                        <li>High Risk Obstetrics</li>
                        <li>Infertility</li>
                        <li>Miscellaneous</li>
                    </ul>

                    <h4>Abstracts to be submitted in the following format:</h4>
                    <ul>
                        <li><strong>Abstract Title:</strong> maximum 20 words</li>
                        <li><strong>Abstract:</strong> maximum 300 words</li>
                        <li>Aims &amp; Objectives</li>
                        <li>Methods</li>
                        <li>Results</li>
                        <li>Conclusions</li>
                    </ul>

                    <h4>Instructions:</h4>
                    <p>Standard abbreviations are acceptable. Uncommon abbreviations must be put in parenthesis and preceded by the full word the first time it appears in the text.</p>

                    <h4>Registration:</h4>
                    <p>The presenting author must be a registered delegate for the conference.</p>

                    <h4>For Accepted Abstracts:</h4>
                    <h5>Oral Papers Presentation</h5>
                    <p><strong>Session/Timings:</strong> 14th and 15th November 2025 from 8:00 am to 6:00 pm (6 minutes presentation plus 2 minutes Q&amp;A).</p>
                    <p><strong>Guidelines for Presentation:</strong> Presentation should be made in PPT 16:9 horizontal format. Your presentation has to be submitted via email on <a href="mailto:abstract@starsampoornapune.com">abstract@starsampoornapune.com</a> by 31st October 2025.</p>

                    <h5>ePoster Presentation</h5>
                    <p><strong>Session/Timings:</strong> 14th and 15th November 2025 (3 minutes presentation plus 2 minutes Q&amp;A). ePosters will be displayed during the conference on LED TVs.</p>

                    <h5>Guidelines for ePoster Presentation:</h5>
                    <ul>
                        <li>File format should be PDF in 16:9 orientation (prepare in PPT and save as PDF).</li>
                        <li>Total size should not exceed 2 MB.</li>
                        <li>Single slide only.</li>
                        <li>Font size at least 14 point.</li>
                        <li>Use simple fonts (e.g. Helvetica/Times New Roman).</li>
                        <li>Light backgrounds → dark fonts; Dark backgrounds → light fonts.</li>
                        <li>Avoid red/green for text or backgrounds.</li>
                        <li>Illustrations/images must be enlarged enough to show details.</li>
                        <li>Submit via email on <a href="mailto:abstract@starsampoornapune.com">abstract@starsampoornapune.com</a> by 31st October 2025.</li>
                    </ul>

                    <h4>Certificates:</h4>
                    <ul>
                        <li>Certificate will only be provided to the presenting author.</li>
                        <li>Presenting author must be physically present at the conference.</li>
                        <li>Certificates will not be handed over to any representative.</li>
                    </ul>

                </div>
            </div>
        </div>
    </section><!-- /Abstract Guidelines Section -->

</main>

<?php require 'includes/footer.php'; ?>
