<?php require 'includes/header.php'; ?>

<style>
  .table-container {
    width: 100%;
    overflow-x: auto;
    margin-top: 30px;
  }

  table {
    width: 100%;
    border-collapse: collapse;
    white-space: nowrap;
    font-size: 14px;
  }

  th,
  td {
    border: 1px solid #888;
    padding: 10px;
    text-align: center;
  }

  th {
    background-color: #004d66;
    color: white;
  }

  .category-header {
    background-color: #f2f2f2;
    font-weight: bold;
  }

  .btn-container {
    display: flex;
    justify-content: center;
    gap: 20px; /* space between buttons */
    flex-wrap: wrap;
  }

  .btn-register,
  .btn-login {
    flex: 1; /* equal width */
    min-width: 220px; /* keeps them wide enough */
    max-width: 315px; /* same max width */
    text-align: center;

    display: inline-block;
    padding: 12px 25px;
    font-size: 16px;
    font-weight: bold;
    color: #fff;
    border: none;
    border-radius: 6px;
    text-decoration: none;
    transition: 0.3s ease;
  }


  .btn-register {
    background-color: #d82e6c;
  }

  .btn-register:hover {
    background-color: #334991;
  }

  .btn-login {
    background-color: #d82e6c;
  }

  .btn-login:hover {
    background-color: #334991;
  }

  /* Terms Section */
  .terms-section h3 {
    margin-top: 20px;
    color: #004d66;
  }

  .terms-section h4 {
    margin-top: 15px;
    color: #004d66;
  }

  .terms-section h4 + p {
    text-indent: 20px;
    margin-bottom: 10px;
    text-align: justify;
  }

  .terms-section p,
  .terms-section li {
    text-align: justify;
    margin-bottom: 10px;
  }

  .terms-section ul {
    padding-left: 20px;
  }
</style>

<main class="main">
  <div class="page-title" data-aos="fade">
    <div class="container">
      <nav class="breadcrumbs">
        <ol>
          <li><a href="index.php">Home</a></li>
          <li class="current">Schedule of Fees</li>
        </ol>
      </nav>
    </div>
  </div>

  <section id="fees" class="fees section">
    <div class="container sub-header-titel" data-aos="fade-up">
      <h2>Schedule of Fees</h2>
    </div>

    <div class="container table-container" data-aos="fade-up" data-aos-delay="100">
      <table>
        <thead>
          <tr>
            <th rowspan="2">Category</th>
            <th colspan="3">MOSCON 2025 Supersaver<br>3rd - 5th Oct, 2025</th>
            <th colspan="3">Early Bird<br>Till 31st March 2026</th>
            <th colspan="3">Regular Slab<br>Till 30th June 2026</th>
            <th colspan="3">Late Slab<br>Till 30th September 2026</th>
            <th colspan="3">Spot Registration<br>1st October Onwards</th>
          </tr>
          <tr>
            <th>Rate</th>
            <th>18% GST</th>
            <th>Total</th>
            <th>Rate</th>
            <th>18% GST</th>
            <th>Total</th>
            <th>Rate</th>
            <th>18% GST</th>
            <th>Total</th>
            <th>Rate</th>
            <th>18% GST</th>
            <th>Total</th>
            <th>Rate</th>
            <th>18% GST</th>
            <th>Total</th>
          </tr>
        </thead>
        <tbody>
          <tr class="category-header">
            <td>MOS Member</td>
            <td>8000</td><td>1440</td><td>9440</td>
            <td>8500</td><td>1530</td><td>10030</td>
            <td>9000</td><td>1620</td><td>10620</td>
            <td>10000</td><td>1800</td><td>11800</td>
            <td>11000</td><td>1980</td><td>12980</td>
          </tr>
          <tr class="category-header">
            <td>NonMOS Member</td>
            <td>9000</td><td>1620</td><td>10620</td>
            <td>8500</td><td>1530</td><td>10030</td>
            <td>10000</td><td>1800</td><td>11800</td>
            <td>11000</td><td>1980</td><td>12980</td>
            <td>12000</td><td>2160</td><td>14160</td>
          </tr>
          <tr class="category-header">
            <td>PG Student</td>
            <td>7000</td><td>1260</td><td>8260</td>
            <td>7500</td><td>1350</td><td>8850</td>
            <td>8000</td><td>1440</td><td>9440</td>
            <td>9000</td><td>1620</td><td>10620</td>
            <td>10000</td><td>1800</td><td>11800</td>
          </tr>
          <tr class="category-header">
            <td>Accompanying Person<br>(Everyone above 8 years)</td>
            <td>7000</td><td>1260</td><td>8260</td>
            <td>7500</td><td>1350</td><td>8850</td>
            <td>8000</td><td>1440</td><td>9440</td>
            <td>9000</td><td>1620</td><td>10620</td>
            <td>10000</td><td>1800</td><td>11800</td>
          </tr>
        </tbody>
      </table>
    </div>
    <br><br>

    <div class="btn-container" data-aos="fade-up" data-aos-delay="150">
      <a href="https://reg.medivisionevents.com/moscon2026/AttendeeReg" target="_blank" class="btn-register">REGISTER NOW</a>
      <a href="https://reg.medivisionevents.com/moscon2026/Login" target="_blank" class="btn-login">ALREADY REGISTERED? LOGIN</a>
    </div>

    <div class="container terms-section" data-aos="fade-up" data-aos-delay="200">
      <div class="row gy-4">
        <div class="col-12">
          <h3>TERMS & CONDITIONS</h3>
          <p><strong>Mandatory Registration:</strong> All attendees, including accompanying children, must be registered for the conference. Entry will not be permitted without a valid registration.</p>

          <h4>A. Children Registration Policy:</h4>
          <ul>
            <li>Children below 8 years of age must be registered for logistical and security purposes; however, no registration fee will be charged.</li>
            <li>Children aged 8 years and above must be registered under the “Accompanying Delegate” category and applicable fees will be charged.</li>
          </ul>

          <h4>B. PG Student Verification:</h4>
          <p>Postgraduate students must upload or submit a valid bonafide certificate from their Head of Department/Institution at the time of registration.</p>

          <h4>C. Non-transferability of Registration:</h4>
          <p>All registrations are strictly non-transferable under any circumstances.</p>

          <h4>D. Charges & Taxes:</h4>
          <p>GST (Goods and Services Tax) is applicable as per government norms and is subject to change.</p>

          <h4>E. Non-refundable Charges:</h4>
          <p>GST and payment gateway charges are non-refundable under any condition, even in the case of cancellation.</p>

          <h4>F. Delegate Kit Collection:</h4>
          <p>Delegate kits will be issued only to the registered delegate upon presentation of the conference badge. Collection on behalf of another delegate will not be allowed.</p>

          <h4>G. Photo ID Requirement:</h4>
          <p>A valid government-issued photo ID is mandatory for entry into the conference venue.</p>

          <h4>H. Spot Registrations:</h4>
          <p>Delegate kits for spot registrants will be provided only subject to availability and cannot be guaranteed.</p>

          <h4>I. Rescheduled Conference:</h4>
          <p>In the event the conference is rescheduled, and the new dates are not suitable to the delegate, no cancellation fee will be charged on the base registration amount (excluding GST and payment gateway charges).</p>

          <h4>J. Communication Protocol:</h4>
          <p>Delegates must mention their registration number in all official communications with the conference secretariat.</p>

          <h4>K. Access for Accompanying Persons:</h4>
          <p>Access for accompanying persons may be restricted to specific areas of the conference venue, as deemed necessary by the organizers.</p>

          <h4>L. Liability Disclaimer:</h4>
          <p>The organizers shall not be held responsible for any changes in dates, loss of personal belongings, or delays in postal or electronic communications.</p>

          <h3>CANCELLATION / REFUND POLICY</h3>
          <ul>
            <li>Cancellations must be emailed from registered email with registration number in subject.</li>
            <li>Cancellation before <strong>31st Jan, 2026</strong>: 25% cancellation fee (excluding GST).</li>
            <li>Cancellation between <strong>1st Feb – 31st May, 2026</strong>: 50% fee.</li>
            <li>Cancellation between <strong>1st June – 31st July, 2026</strong>: 75% fee.</li>
            <li>Cancellation after <strong>1st Aug, 2026</strong>: Non-refundable.</li>
            <li>Refunds within 4 weeks post conference.</li>
            <li>Email timestamp is official request date.</li>
            <li>GST & Payment Gateway charges are non-refundable.</li>
          </ul>
        </div>
      </div>
    </div>
  </section>
</main>

<?php require 'includes/footer.php'; ?>
