<?php require 'includes/header.php'; ?>

<main class="main">

  <!-- Page Title -->
  <div class="page-title" data-aos="fade">
    <div class="container">
      <nav class="breadcrumbs">
        <ol>
          <li><a href="index.php">Home</a></li>
          <li class="current">About MOSCON 2026</li>
          <li class="current">Venue</li>
        </ol>
      </nav>
    </div>
  </div>

  <!-- Venue Section -->
  <section id="venue" class="team section">
    <div class="container sub-header-titel aos-init aos-animate" data-aos="fade-up">
      <h2 class="mb-4">Venue</h2>

      <!-- Venue Title -->
      <div class="row">
        <div class="col">
          <h5 class="text-center text-md-start">
            Jio World Convention Centre, Bandra Kurla Complex (BKC)
          </h5>
        </div>
      </div>

      <!-- Venue Description -->
      <div class="row">
        <div class="col">
          <p>
            With an area totalling 1,03,012 sq. m., Jio World Convention Centre is India’s foremost venue
            for best-in-class exhibitions, conventions, meetings and social events. The highly flexible
            and dynamic venue is equipped to simultaneously host physical, virtual and hybrid events.
          </p>
        </div>
      </div>

      <!-- Venue Images Row 1 -->
      <div class="row">
        <div class="col-sm-3 mb-4">
          <img class="img-fluid rounded" src="img/facade1.jpg" alt="Facade 1" />
        </div>
        <div class="col-sm-3 mb-4">
          <img class="img-fluid rounded" src="img/facade2.jpg" alt="Facade 2" />
        </div>
        <div class="col-sm-3 mb-4">
          <img class="img-fluid rounded" src="img/facade3.jpg" alt="Facade 3" />
        </div>
        <div class="col-sm-3 mb-4">
          <img class="img-fluid rounded" src="img/facade4.jpg" alt="Facade 4" />
        </div>
      </div>

      <!-- Venue Description 2 -->
      <div class="row mt-3">
        <div class="col">
          <p>
            Consisting of 5 Modular Halls, 25 meeting rooms and 1 ballroom, the venue is designed to
            promote learning and interaction while boosting overall delegate experience and comfort.
          </p>
        </div>
      </div>

      <!-- Venue Images Row 2 -->
      <div class="row">
        <div class="col-sm-3 mb-4">
          <img class="img-fluid rounded" src="img/room1.jpg" alt="Room 1" />
        </div>
        <div class="col-sm-3 mb-4">
          <img class="img-fluid rounded" src="img/room2.jpg" alt="Room 2" />
        </div>
        <div class="col-sm-3 mb-4">
          <img class="img-fluid rounded" src="img/room3.jpg" alt="Room 3" />
        </div>
        <div class="col-sm-3 mb-4">
          <img class="img-fluid rounded" src="img/room4.jpg" alt="Room 4" />
        </div>
      </div>

      <!-- Transport Options -->
      <div class="row transport mt-4 text-center">
        <div class="col mb-4">
          <div class="icon-back">
            <img class="img-fluid" src="img/Cab-Blue.png" alt="Cab" />
            <h4>Car/Cab</h4>
            <p>Venue is easily locatable on maps</p>
          </div>
        </div>
        <div class="col mb-4">
          <div class="icon-back">
            <img class="img-fluid" src="img/Flight-Blue.png" alt="Flight" />
            <h4>Airport</h4>
            <p>Chhatrapati Shivaji International Airport 30 minute drive</p>
          </div>
        </div>
        <div class="col mb-4">
          <div class="icon-back">
            <img class="img-fluid" src="img/Train-Blue.png" alt="Metro" />
            <h4>Upcoming Metro</h4>
            <p>Lines 2 and 3 (7-10 minute walk)</p>
          </div>
        </div>
        <div class="col mb-4">
          <div class="icon-back">
            <img class="img-fluid" src="img/Bus-Blue.png" alt="Bus" />
            <h4>Bus</h4>
            <p>BEST buses going to BKC<br />Monday-Sunday, from 6 AM – 9 PM</p>
          </div>
        </div>
        <div class="col mb-4">
          <div class="icon-back">
            <img class="img-fluid" src="img/Train-Blue.png" alt="Train" />
            <h4>Train</h4>
            <p>Closest stations are Bandra, Kurla, and Santacruz (10-20 minute drive)</p>
          </div>
        </div>
      </div>

    </div>
  </section>

  <!-- Google Maps Section -->
  <section style="margin-bottom: -20px;">
    <iframe
      src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d30168.123839040883!2d72.867031!3d19.063057!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3be7c92c52ba277b%3A0x6d3883f7179587e3!2sJio%20World%20Centre!5e0!3m2!1sen!2sin!4v1695538467706!5m2!1sen!2sin"
      width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
      referrerpolicy="no-referrer-when-downgrade"></iframe>
  </section>

</main>

<?php require 'includes/footer.php'; ?>
